// augform-ad-loader.js
function loadAd(uuid, fullUrl, wrapperId, resp) {
    var container = document.getElementById(wrapperId);
    if (!container) {
        console.log("Container not found for UUID:", uuid);
        return;
    }

    if (resp === 'i') {
        // Directly set the image URL
        var img = document.createElement('img');
        img.src = fullUrl; // Use the URL directly
        img.style.width = '100%';
        img.style.height = 'auto';
        container.innerHTML = '';
        container.appendChild(img);
    } else {
        // Handle HTML or other responses
        fetch(fullUrl)
            .then(function(res) {
                return res.text();
            })
            .then(function(html) {
                container.innerHTML = html;

                if (html.includes("<map") && typeof jQuery === 'undefined' && !window.__augform_jquery_loading) {
                    window.__augform_jquery_loading = true;
                    var script = document.createElement("script");
                    script.src = "https://code.jquery.com/jquery-3.6.0.min.js";
                    script.onload = function() {
                        window.__augform_jquery_loaded = true;
                    };
                    document.head.appendChild(script);
                }
            })
            .catch(function(error) {
                console.error("AugforM fetch error:", error);
            });
    }
}

document.addEventListener("DOMContentLoaded", function() {
    console.log("Script loaded");

});
