<?php
/*
 * Plugin Name: AugforM Image Viewer
 * Description: A plugin to display images with advertisements.
 * Version: 1.0
 * Author: Andrii Mytroshyn
 * Author URI: https://augform.com/Forms/profile.php?name=andrii.mytroshyn
 * Plugin URI: https://augform.com/resource/plugins/wp_plugin.html
*/

function enqueue_augform_ad_loader_script() {
    wp_enqueue_script(
        'augform-ad-loader',
        plugin_dir_url(__FILE__) . 'js/augform-ad-loader.js',
        [],
        null,
        true
    );
}
add_action('wp_enqueue_scripts', 'enqueue_augform_ad_loader_script');

function augform_image_viewer_shortcode($atts) {
    $atts = shortcode_atts([
        'uuid' => '',
        'link' => '1',
        'resp' => 'a' // Changed from 'loadtype' to 'resp'
    ], $atts);

    if (empty($atts['uuid'])) {
        return '<!-- AugforM Image Viewer: UUID is required -->';
    }

    $uuid = esc_attr($atts['uuid']);
    $uuid_safe = preg_replace('/[^a-zA-Z0-9_]/', '_', $uuid); // For use in JS function names
    $link = esc_attr($atts['link']);
    $resp = esc_attr($atts['resp']); // Use 'resp' instead of 'loadtype'

    $base_url = "https://augform.com/getImage2d.php";
    $wrapper_id = 'augform-wrapper-' . $uuid;

    ob_start();
    ?>
    <div id="<?php echo esc_attr($wrapper_id); ?>" class="augform-ad-wrapper"></div>
    <script>
    document.addEventListener("DOMContentLoaded", function() {
        var wrapper = document.getElementById("<?php echo esc_js($wrapper_id); ?>");
        if (wrapper) {
            var resizeObserver = new ResizeObserver(entries => {
                for (let entry of entries) {
                    var width = entry.contentRect.width;
                    var height = entry.contentRect.height;
                    var fullUrl = "<?php echo esc_url_raw($base_url); ?>?uuid=<?php echo esc_js($uuid); ?>&resp=<?php echo esc_js($resp); ?>&link=<?php echo esc_js($link); ?>&width=" + width + "&height=" + height;
                    loadAd("<?php echo esc_js($uuid_safe); ?>", fullUrl, "<?php echo esc_js($wrapper_id); ?>",  "<?php echo esc_js($resp); ?>");
                    // Disconnect the observer after the first resize event
                    resizeObserver.disconnect();
                }
            });
            resizeObserver.observe(wrapper);
        } else {
            console.log("Wrapper not found");
        }
    });
    </script>
    <?php
    return ob_get_clean();
}


add_shortcode('augform_image', 'augform_image_viewer_shortcode');
?>
